package editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewRadioPaletteObjectWizard extends JPanel {
	
	private JTextField waveFile;
	private JTextField radioLabel;
	private SharedColor labelColor;
	private MicroColorCanvas colorCanvas;
	private JDialog frame;
	private boolean wasCancelled = true;
	
	
	private String waveFileStr;
	private String captionStr;
	
	private static ImageIcon previewPlay;
	private static ImageIcon previewPause;
	private static ImageIcon previewStop;
	
	private Clip previewClip;
	
	
	
	public NewRadioPaletteObjectWizard(JDialog theFrame) {
		
		
		if(previewPlay == null) {
			previewPlay = new ImageIcon(NewRadioPaletteObjectWizard.class.getResource("/images/preview_play.GIF"));
		}
		
		if(previewPause == null) {
			previewPause = new ImageIcon(NewRadioPaletteObjectWizard.class.getResource("/images/preview_pause.GIF"));
		}
		
		if(previewStop == null) {
			previewStop = new ImageIcon(NewRadioPaletteObjectWizard.class.getResource("/images/preview_stop.GIF"));
		}
		
		
		frame = theFrame;
		frame.setTitle("New Radio");
		
		this.setLayout(new BorderLayout());
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(3, 1));
		mainPanel.add(new JPanel());
		
		JPanel upperPanel = new JPanel();
		upperPanel.setLayout(new FlowLayout());
		upperPanel.add(new JLabel("sound file:"));
		waveFile = new JTextField(33);
		waveFile.setHorizontalAlignment(JTextField.CENTER);
		waveFile.setEditable(false);
		upperPanel.add(waveFile);
		JButton fileBrowse = new JButton("Browse...");
		fileBrowse.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				retrieveSoundFile(waveFile, frame);
			}
		});
		upperPanel.add(fileBrowse);
		
		
		JButton playButton = new JButton(previewPlay);
		playButton.setRolloverIcon(previewPlay);
		playButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				if(previewClip != null) {
					if(previewClip.isActive() || previewClip.getFrameLength() - 1 <= previewClip.getFramePosition())
						previewClip.setFramePosition(0);
					previewClip.start();
				}
			}
		});
		upperPanel.add(playButton);
		
		JButton pauseButton = new JButton(previewPause);
		pauseButton.setRolloverIcon(previewPause);
		pauseButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				if(previewClip != null) {
					previewClip.stop();
				}
			}
		});
		upperPanel.add(pauseButton);
		
		JButton stopButton = new JButton(previewStop);
		stopButton.setRolloverIcon(previewStop);
		stopButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				if(previewClip != null) {
					previewClip.stop();
					previewClip.setFramePosition(0);
				}
			}
		});
		upperPanel.add(stopButton);
		
		mainPanel.add(upperPanel);
		

		JPanel lowerPanel = new JPanel(new GridLayout(1, 2));
		JPanel colorPanel = new JPanel(new FlowLayout());
		colorPanel.add(new JLabel("Label color (optional): "));
		labelColor = new SharedColor();
		colorCanvas = new MicroColorCanvas(labelColor);
		colorPanel.add(colorCanvas);
		JButton changeColorButton = new JButton("Change...");
		changeColorButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(labelColor, colorCanvas);
			}
		});
		colorPanel.add(changeColorButton);
		lowerPanel.add(colorPanel);
		
		JPanel textPanel = new JPanel(new FlowLayout());
		textPanel.add(new JLabel("Label (optional): "));
		radioLabel = new JTextField(3);
		textPanel.add(radioLabel);
		lowerPanel.add(textPanel);
		
		mainPanel.add(lowerPanel);
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel okCancelPanel = new JPanel(new GridLayout(1, 4));
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				// TODO Auto-generated method stub
				wasCancelled = true;
				frame.dispose();
				if(previewClip != null)
					previewClip.stop();
					
			}
		});
		okCancelPanel.add(cancel);
		
		okCancelPanel.add(new JPanel());
		okCancelPanel.add(new JPanel());
		
		JButton ok = new JButton("OK");
		ok.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				okWasPressed();
				
			}
		});
		okCancelPanel.add(ok);
		
		
		this.add(okCancelPanel, BorderLayout.SOUTH);
		
		
		
	}
	
	
	public static NewRadioPaletteObjectWizard openWizard() {
		
		JDialog frame = new JDialog();
		NewRadioPaletteObjectWizard returnValue = new NewRadioPaletteObjectWizard(frame);
		frame.setContentPane(returnValue);
		frame.setModal(true);
		frame.setSize(new Dimension(800, 300));
		frame.setVisible(true);
		
		frame.dispose();
		
		return returnValue;
		
	}
	
	
	public static NewRadioPaletteObjectWizard openWizard(String theFileName, String theCaption, Color theCaptionColor, Clip theClip) {
		
		JDialog frame = new JDialog();
		NewRadioPaletteObjectWizard returnValue = new NewRadioPaletteObjectWizard(frame, theFileName, theCaption, theCaptionColor, theClip);
		frame.setContentPane(returnValue);
		frame.setModal(true);
		frame.setSize(new Dimension(800, 300));
		frame.setVisible(true);
		
		frame.dispose();
		
		return returnValue;
		
	}
	
	
	public static void main(String [] args) {
		
		openWizard();
		
	}
	
	
	public boolean wasCancelled() {
		return wasCancelled;
	}
	
	private void okWasPressed() {
		
		if(waveFile.getText() == null || waveFile.getText().trim().length() == 0) {
			JOptionPane.showMessageDialog(this, "You must select a sound file for the radio.\n", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		if((radioLabel.getText() == null || radioLabel.getText().trim().length() == 0) && labelColor.getColor() != null) {
			int resp = JOptionPane.showConfirmDialog(this, "You've set the color but not the caption.  Do you want this radio to have no label?","Confirm", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
			if(resp == JOptionPane.NO_OPTION) {
				return;
			}
		} else if(labelColor.getColor() == null && (radioLabel.getText() != null && radioLabel.getText().trim().length() > 0)) {
			int resp = JOptionPane.showConfirmDialog(this, "You've set the caption but not the color.  Do you want this radio to have no label?","Confirm", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
			if(resp == JOptionPane.NO_OPTION) {
				return;
			}
		}
		

		waveFileStr = waveFile.getText().trim();
		
		captionStr = radioLabel.getText();
		if(captionStr != null)
			captionStr = captionStr.trim();
		
		wasCancelled = false;
		frame.dispose();
		
		previewClip.stop();
		
	}


	public String getWaveFile() {
		return waveFileStr;
	}


	public String getCaption() {
		return captionStr;
	}
	
	public Color getCaptionColor() {
		return labelColor.getColor();
	}
	
	
	
	public void retrieveSoundFile(JTextField textArea, Window theEncasingFrame) {
		
		
		FileDialog fd = null;
		
		if(theEncasingFrame instanceof JDialog) {
			fd = new FileDialog((JDialog) theEncasingFrame, "Select Sound File", FileDialog.LOAD);
		} else {
			fd = new FileDialog((JFrame) theEncasingFrame, "Select Sound File", FileDialog.LOAD);
		}
		fd.setModal(true);
		
//		System.out.println("about to set visible to true!");
		
		fd.setVisible(true);
		
//		System.out.println("just set visible to true!");
		
		
		
		
		
		if(fd.getDirectory() != null && fd.getFile() != null) {
			
			
			//DELME gotta put in the loading here
			try {
				previewClip = loadGivenClip(fd.getDirectory() + fd.getFile());
			} catch(Exception e) {
				JOptionPane.showMessageDialog(this, "The given file was not a recognized sound file format.  (Sorry if you wanted something other than WAV...)","Error loading sound file", JOptionPane.ERROR_MESSAGE);
				return;
			}
			
			
			textArea.setEditable(true);
			textArea.setText(fd.getDirectory() + fd.getFile());
			textArea.setEditable(false);
			textArea.repaint();
//			System.out.println("just set the text to <<" + fd.getDirectory() + fd.getFile() + ">>");
		}
		
		fd.dispose();
		
	}
	
	
	
	public static Clip loadGivenClip(String fileName) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
		
		Clip returnValue = null;
		
		AudioInputStream ais;
		
			ais = AudioSystem.getAudioInputStream(new File(fileName));
			AudioFormat af = ais.getFormat();
			
			if(af.getEncoding() == AudioFormat.Encoding.ALAW ||
					af.getEncoding() == AudioFormat.Encoding.ULAW ) {
				
				AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED,
						af.getSampleRate(),
						af.getSampleSizeInBits() * 2,
						af.getChannels(),
						af.getFrameSize() * 2,
						af.getFrameRate(),
						true);
				
				ais = AudioSystem.getAudioInputStream(newFormat, ais);
				af = newFormat;
				
			}
			
			DataLine.Info inf = new DataLine.Info(Clip.class, af);
			
			if(!AudioSystem.isLineSupported(inf)) {
				JOptionPane.showMessageDialog(null, "ERROR:  The clip isn't supported!");
			}
			
			returnValue = (Clip) AudioSystem.getLine(inf);
			returnValue.open(ais);
			ais.close();
		
		
		return returnValue;
	}
	
	
	public Clip getClip() {
		return previewClip;
	}
	
	
	
	
	
	
	public NewRadioPaletteObjectWizard(JDialog theFrame,
									   String theFileName,
									   String theCaption,
									   Color theCaptionColor,
									   Clip theClip) {
		
		previewClip = theClip;
		
		if(previewPlay == null) {
			previewPlay = new ImageIcon(NewRadioPaletteObjectWizard.class.getResource("/images/preview_play.GIF"));
		}
		
		if(previewPause == null) {
			previewPause = new ImageIcon(NewRadioPaletteObjectWizard.class.getResource("/images/preview_pause.GIF"));
		}
		
		if(previewStop == null) {
			previewStop = new ImageIcon(NewRadioPaletteObjectWizard.class.getResource("/images/preview_stop.GIF"));
		}
		
		
		frame = theFrame;
		frame.setTitle("New Radio");
		
		this.setLayout(new BorderLayout());
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(3, 1));
		mainPanel.add(new JPanel());
		
		JPanel upperPanel = new JPanel();
		upperPanel.setLayout(new FlowLayout());
		upperPanel.add(new JLabel("sound file:"));
		waveFile = new JTextField(33);
		waveFile.setText(theFileName);
		waveFile.setHorizontalAlignment(JTextField.CENTER);
		waveFile.setEditable(false);
		upperPanel.add(waveFile);
		JButton fileBrowse = new JButton("Browse...");
		fileBrowse.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				retrieveSoundFile(waveFile, frame);
			}
		});
		upperPanel.add(fileBrowse);
		
		
		JButton playButton = new JButton(previewPlay);
		playButton.setRolloverIcon(previewPlay);
		playButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				if(previewClip != null) {
					if(previewClip.isActive() || previewClip.getFrameLength() - 1 <= previewClip.getFramePosition())
						previewClip.setFramePosition(0);
					previewClip.start();
				}
			}
		});
		upperPanel.add(playButton);
		
		JButton pauseButton = new JButton(previewPause);
		pauseButton.setRolloverIcon(previewPause);
		pauseButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				if(previewClip != null) {
					previewClip.stop();
				}
			}
		});
		upperPanel.add(pauseButton);
		
		JButton stopButton = new JButton(previewStop);
		stopButton.setRolloverIcon(previewStop);
		stopButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				if(previewClip != null) {
					previewClip.stop();
					previewClip.setFramePosition(0);
				}
			}
		});
		upperPanel.add(stopButton);
		
		mainPanel.add(upperPanel);
		

		JPanel lowerPanel = new JPanel(new GridLayout(1, 2));
		JPanel colorPanel = new JPanel(new FlowLayout());
		colorPanel.add(new JLabel("Label color (optional): "));
		labelColor = new SharedColor();
		labelColor.setColor(theCaptionColor);
		colorCanvas = new MicroColorCanvas(labelColor);
		colorPanel.add(colorCanvas);
		JButton changeColorButton = new JButton("Change...");
		changeColorButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(labelColor, colorCanvas);
			}
		});
		colorPanel.add(changeColorButton);
		lowerPanel.add(colorPanel);
		
		JPanel textPanel = new JPanel(new FlowLayout());
		textPanel.add(new JLabel("Label (optional): "));
		radioLabel = new JTextField(3);
		radioLabel.setText(theCaption);
		textPanel.add(radioLabel);
		lowerPanel.add(textPanel);
		
		mainPanel.add(lowerPanel);
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel okCancelPanel = new JPanel(new GridLayout(1, 4));
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				// TODO Auto-generated method stub
				wasCancelled = true;
				frame.dispose();
				if(previewClip != null)
					previewClip.stop();
					
			}
		});
		okCancelPanel.add(cancel);
		
		okCancelPanel.add(new JPanel());
		okCancelPanel.add(new JPanel());
		
		JButton ok = new JButton("OK");
		ok.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				okWasPressed();
				
			}
		});
		okCancelPanel.add(ok);
		
		
		this.add(okCancelPanel, BorderLayout.SOUTH);
		
		
		
	}
	
	
}
